<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once('lib/Config_RechPay.php');
require_once('lib/RechPayChecksum.php');

$secret = 'DRocpf8V0Y';

/* BASIC CHECK */
if (!isset($_POST['hash'])) {
    header("Location: payment-failed.php");
    exit;
}

/* DECRYPT DATA */
$encoded = hash_decrypt($_POST['hash'], $secret);
$pdata = json_decode($encoded, true);

/* PRODUCT URL MAP */
$productUrls = [
  "Print Portal Auto update Source Code" => "https://yourdomain.com/products/print-portal.zip",
  "All In One Print Portal Source Code" => "apnacsc.xyz",
  "RTPS Certificate All State + Birth Certificate Source Code" => "https://yourdomain.com/products/rtps.zip",
  "Dc Original Birth Certificate Source Code" => "https://yourdomain.com/products/dc-birth.zip",
  "E-Commerce Website Source Code" => "https://yourdomain.com/products/ecommerce.zip",
  "Paytm Payment Gateway Source Code" => "https://yourdomain.com/products/paytm-gateway.zip",
  "All in 6 Merchant Payment Gateway Source Code" => "https://yourdomain.com/products/all-gateway.zip",
  "UCL Portal Source Code" => "https://yourdomain.com/products/ucl.zip"
];

/* VALIDATE PAYMENT */
if (
    isset($pdata['txnStatus']) &&
    $pdata['txnStatus'] === "TXN_SUCCESS" &&
    !empty($pdata['payee_vpa'])
) {

    $productKey = $pdata['sender_note'] ?? '';

    /* CHECK PRODUCT */
    if (!isset($productUrls[$productKey])) {
        header("Location: payment-success.php?msg=PAID_BUT_PRODUCT_NOT_FOUND");
        exit;
    }

    $productUrl = $productUrls[$productKey];

    /* OPTIONAL: LOG TRANSACTION */
    file_put_contents(
        "payment-log.txt",
        date("Y-m-d H:i:s")." | ".json_encode($pdata).PHP_EOL,
        FILE_APPEND
    );

    /* 🔥 DIRECT PRODUCT REDIRECT */
    header("Location: ".$productUrl);
    exit;

} else {
    header("Location: payment-failed.php");
    exit;
}
?>
