<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once __DIR__ . '/lib/Config_RechPay.php';
require_once __DIR__ . '/lib/RechPayChecksum.php';

/* RECEIVE POST */
$gateway_type = $_POST['gateway_type'] ?? '';
$cust_Mobile  = $_POST['cust_Mobile'] ?? '';
$cust_Email   = $_POST['cust_Email'] ?? '';
$txnAmount    = $_POST['txnAmount'] ?? '';
$txnNote      = $_POST['txnNote'] ?? '';

if ($txnAmount == '' || $cust_Mobile == '') {
    die("INVALID REQUEST DATA");
}

/* CREDENTIALS */
$token  = "d2830e-d449a4-0d49db-1c87a1-be4039";
$secret = "DRocpf8V0Y";

/* ORDER */
$orderId = "UPI_TECH_" . time();
$callback_url = "https://entry.fastfind.live/txnResult.php";

/* GATEWAY CONFIG */
$RECHPAY_TXN_URL = 'https://apnacsc.xyz/order/process';
$upiuid = 'paytmqr281005050101k2h2ao5hi21j@paytm';

/* PARAM LIST */
$paramList = [
    "upiuid"       => $upiuid,
    "token"        => $token,
    "orderId"      => $orderId,
    "txnAmount"    => $txnAmount,
    "txnNote"      => $txnNote,
    "callback_url" => $callback_url,
    "cust_Mobile"  => $cust_Mobile,
    "cust_Email"   => $cust_Email
];

/* CHECKSUM */
$checkSum = RechPayChecksum::generateSignature($paramList, $secret);

if (!$checkSum) {
    die("CHECKSUM GENERATION FAILED");
}
?>
<!DOCTYPE html>
<html>
<head>
<title>Redirecting to Payment</title>
</head>
<body>

<h3>Please do not refresh, redirecting to payment…</h3>

<form method="post" action="<?php echo htmlspecialchars($RECHPAY_TXN_URL); ?>" name="rechpayForm">
<?php
foreach ($paramList as $k => $v) {
    echo '<input type="hidden" name="'.$k.'" value="'.htmlspecialchars($v).'">';
}
?>
<input type="hidden" name="checksum" value="<?php echo htmlspecialchars($checkSum); ?>">
</form>

<script>
document.rechpayForm.submit();
</script>

</body>
</html>
